#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_LockRecordException : BaseTest 
	{
		private string exceptionText = "LockRecordException";
		private string innerText = "InnerException";
		private string genericErrorText = "Exception of type 'gov.va.med.vbecs.BOL.LockRecordException' was thrown.";

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.LockRecordException))]
		public void Ctor_Pass()
		{			
			throw new BOL.LockRecordException();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void Ctor_Fail()
		{
		}

		
		[Test]
		public void Ctor_String_Pass()
		{		
			try
			{
				throw new BOL.LockRecordException(exceptionText);
			}
			catch (BOL.LockRecordException ex)
			{
				Assert.AreEqual(exceptionText, ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Fail()
		{
			try
			{
				throw new BOL.LockRecordException(null);
			}
			catch (BOL.LockRecordException ex)
			{
				Assert.AreEqual(ex.Message, genericErrorText);
			}
		}

				
		[Test]
		public void Ctor_String_Exception_Pass()
		{			
			try
			{
				throw new BOL.LockRecordException(exceptionText, new Exception(innerText));
			}
			catch (BOL.LockRecordException ex)
			{
				Assert.AreEqual(exceptionText, ex.Message);
				Assert.AreEqual(innerText, ex.InnerException.Message);
			}
		}

		[Test]
		public void Ctor_String_Exception_Fail()
		{
			try
			{
				throw new BOL.LockRecordException(null, null);
			}
			catch (BOL.LockRecordException ex)
			{
				Assert.AreEqual(genericErrorText, ex.Message);
				Assert.IsNull(ex.InnerException);
			}
		}

	}
}
#endif

